OWNER({{cookiecutter.yamake_owner}})

PY3_LIBRARY()

PEERDIR(
    contrib/python/aiosocksy
    contrib/python/uvloop
    library/python/resource
    mail/python/sendr-qtools
)

PY_SRCS(
    __init__.py
    api/app.py
    api/schemas/base.py
    api/schemas/user.py
    api/exceptions.py
    api/handlers/base.py
    api/handlers/user.py
    api/handlers/utility.py
    api/middlewares.py
    api/routes/user.py
    api/routes/utility.py
    commands/pg_pinger_env.py
    commands/runserver.py
    commands/runworkers.py
    conf.py
    core/actions/base.py
    core/actions/ping_db.py
    core/actions/user.py
    core/context.py
    core/exceptions.py
    interactions/__init__.py
    interactions/base.py
    manage.py
    storage/__init__.py
    storage/db/tables.py
    storage/entities/enums.py
    storage/entities/user.py
    storage/entities/task.py
    storage/exceptions.py
    storage/mappers/base.py
    storage/mappers/task.py
    storage/mappers/user.py
    storage/mappers/worker.py
    taskq/__init__.py
    taskq/app.py
    taskq/arbiter.py
    taskq/workers/__init__.py
    taskq/workers/action.py
    taskq/workers/base.py
    utils/cli.py
    utils/db.py
    utils/logging.py
    utils/stats.py
    utils/tvm.py
)

RESOURCE_FILES(
    settings/000-logging.conf
    settings/010-common.conf
    settings/020-database.conf
    settings/020-database.conf.development
    settings/020-database.conf.testing
    settings/030-interactions.conf
    settings/040-tvm.conf
    settings/040-tvm.conf.development
    settings/050-taskq.conf
)

END()

RECURSE_FOR_TESTS(tests)
